cd "Z:\work\Baze\SILC_Serbia\2019"
/* offical data:
https://publikacije.stat.gov.rs/G2020/Pdf/G20201283.pdf
https://www.stat.gov.rs/sr-Latn/oblasti/potrosnja-prihodi-i-uslovi-zivota
*/

*check household income
use h-file, clear
merge 1:m idhh using r-file

* generate adult equivalent index for each household
bysort idhh: egen nadults=sum(age>=14)
bysort idhh: egen nchildren=sum(age<14)
gen adulteq=1+0.5*(nadults-1) + 0.3*(nchildren)

* caclulate income per adult equivalent
gen income_ae = dispy/adulteq

* calculate poverty line
sum income_ae [aw=weight] , d
gen povline =r(p50)*0.60
sum povline

* poverty indicator
gen pov60 = income_ae<povline

* poverty rate
ta pov60 [iw=weight]

ta pov60 female [iw=weight], col

gen age_gr = age 
recode age_gr (0/17=1) (18/64=2) (65/150=3)
sum age age_gr

ta pov60 age_gr [iw=weight], col

* inequality
* ssc install ineqdec0 // if you need to instal it
ineqdec0 income_ae  [aw=weight]
